/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.preferences;

import com.aptana.editor.common.preferences.CommonEditorPreferencePage;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.CSSSourceEditor;
import com.aptana.editor.css.preferences.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class CSSPreferencePage
extends CommonEditorPreferencePage {
    private BooleanFieldEditor foldComments;
    private BooleanFieldEditor foldRules;
    private Composite foldingGroup;

    public CSSPreferencePage() {
        this.setDescription(Messages.CSSPreferencePage_CSS_Page_Title);
        this.setPreferenceStore(CSSPlugin.getDefault().getPreferenceStore());
    }

    protected IPreferenceStore getChainedEditorPreferenceStore() {
        return CSSSourceEditor.getChainedPreferenceStore();
    }

    protected IEclipsePreferences getPluginPreferenceStore() {
        return InstanceScope.INSTANCE.getNode("com.aptana.editor.css");
    }

    protected Composite createFoldingOptions(Composite parent) {
        this.foldingGroup = super.createFoldingOptions(parent);
        Label initialFoldLabel = new Label(this.foldingGroup, 64);
        initialFoldLabel.setText(Messages.CSSPreferencePage_initial_fold_options_label);
        this.foldComments = new BooleanFieldEditor("fold_comments", Messages.CSSPreferencePage_fold_comments_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldComments);
        this.foldRules = new BooleanFieldEditor("fold_rules", Messages.CSSPreferencePage_fold_rules_label, this.foldingGroup);
        this.addField((FieldEditor)this.foldRules);
        return this.foldingGroup;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.enableFolding) {
            Object newValue = event.getNewValue();
            if (Boolean.TRUE == newValue) {
                this.foldComments.setEnabled(true, this.foldingGroup);
                this.foldRules.setEnabled(true, this.foldingGroup);
            } else {
                this.foldComments.setEnabled(false, this.foldingGroup);
                this.foldRules.setEnabled(false, this.foldingGroup);
            }
        }
        super.propertyChange(event);
    }
}

